/* Copyright (c) 2008, Oracle. All rights reserved. */

import java.io.*;

public class LASPointDataRecord{

	byte[] x=new byte[4];
	byte[] y=new byte[4];
	byte[] z=new byte[4];
	byte[] intensity=new byte[2];

	byte[] parseOnlyRnNorSdrEofl=new byte[1];
	byte[] returnNumber=new byte[1];
	byte[] numberOfReturns=new byte[1];
	byte[] scanDirectionFlag=new byte[1];
	byte[] edgeOfFlightLine=new byte[1];

	byte[] classification=new byte[1];
	byte[] scanAngleRank=new byte[1];
	byte[] fileMarker=new byte[1];
	byte[] userBitField=new byte[2];

	byte[] extraData;


	public LASPointDataRecord(){
		try{
			jbInit();
		} catch(Exception ex){
			ex.printStackTrace();
		}

	}

	public static LASPointDataRecord createPointDataRecord(int pointDataFormatID){
		if(pointDataFormatID==0){
			return new LASPointDataRecordFormat0();
		} else if(pointDataFormatID==1){
			return new LASPointDataRecordFormat1();
		} else{
			System.out.println("Illegal record format ID");
		}
		return null;
	}

	public void parse(InputStream inputStream, int pointDataRecordLength){
		try{
			inputStream.read(x);
			inputStream.read(y);
			inputStream.read(z);
			inputStream.read(intensity);

			inputStream.read(parseOnlyRnNorSdrEofl);
			returnNumber[0]=(byte)((parseOnlyRnNorSdrEofl[0]>>0)&0x07);
			numberOfReturns[0]=(byte)((parseOnlyRnNorSdrEofl[0]>>3)&0x07);
			scanDirectionFlag[0]=(byte)((parseOnlyRnNorSdrEofl[0]>>6)&0x01);
			edgeOfFlightLine[0]=(byte)((parseOnlyRnNorSdrEofl[0]>>7)&0x01);

			inputStream.read(classification);
			inputStream.read(scanAngleRank);
			inputStream.read(fileMarker);
			inputStream.read(userBitField);

		}catch(IOException exception){
			exception.printStackTrace();
		}
	}

	public void write(OutputStream outputStream,int pointDataRecordLength){
		try{
			outputStream.write(x);
			outputStream.write(y);
			outputStream.write(z);
			outputStream.write(intensity);

			parseOnlyRnNorSdrEofl[0]=(byte)(((returnNumber[0]&0x07)<<0)|((numberOfReturns[0]&0x07)<<3)|((scanDirectionFlag[0]&0x01)<<6)|((edgeOfFlightLine[0]&0x01)<<7));
			outputStream.write(parseOnlyRnNorSdrEofl);

			outputStream.write(classification);
			outputStream.write(scanAngleRank);
			outputStream.write(fileMarker);
			outputStream.write(userBitField);

		}catch(IOException exception){
			exception.printStackTrace();
		}
	}

	static public void readStartSignature(InputStream inputStream){
		byte[] startSignature=new byte[2];
		try{
			inputStream.read(startSignature);
			if(littleEndianArray2ToInt(startSignature)!=0xCCDD){
				System.out.println("Stream out of alignment.");
			}
		}catch(IOException exception){
			exception.printStackTrace();
		}
	}

	static public void writeStartSignature(OutputStream outputStream){
		byte[] startSignature=new byte[2];
		startSignature[0]=(byte)0xDD;
		startSignature[1]=(byte)0xCC;
		try{
			outputStream.write(startSignature);
		}catch(IOException exception){
			exception.printStackTrace();
		}
	}

	public String arrayToString(byte[] array){
		String string=new String(array);
		int breakPoint=string.length();
		for(int a=0;a<string.length();a++){
			if(string.charAt(a)<32 || string.charAt(a)>126){
				breakPoint=a;
				break;
			}
		}
		string=string.substring(0,breakPoint);
		return string;
	}

	public byte[] stringToArray(int arraySize,String string){
		byte[] array=new byte[arraySize];
		if(string==null){
			string=new String();
		}
		for(int a=0;a<string.length();a++){
			array[a]=(byte)string.charAt(a);
		}
		for(int a=string.length();a<arraySize;a++){
			array[a]=(char)0x0;
		}
		return array;
	}


	public double littleEndianArray8ToDouble(byte[] array){
		long longBits=(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24)|(((long)array[4]&0xFFL)<<32)|(((long)array[5]&0xFFL)<<40)|(((long)array[6]&0xFFL)<<48)|(((long)array[7]&0xFFL)<<56);
		return java.lang.Double.longBitsToDouble(longBits);
	}

	public byte[] doubleToLittleEndianArray8(Double number){
		byte[] array=new byte[8];
		long l = Double.doubleToLongBits(number);
		array[0]=(byte)((l>>0)&0xFFL);
		array[1]=(byte)((l>>8)&0xFFL);
		array[2]=(byte)((l>>16)&0xFFL);
		array[3]=(byte)((l>>24)&0xFFL);
		array[4]=(byte)((l>>32)&0xFFL);
		array[5]=(byte)((l>>40)&0xFFL);
		array[6]=(byte)((l>>48)&0xFFL);
		array[7]=(byte)((l>>56)&0xFFL);

		return array;
	}

	public long littleEndianArray8ToLong(byte[] array){
		return(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24)|(((long)array[4]&0xFFL)<<32)|(((long)array[5]&0xFFL)<<40)|(((long)array[6]&0xFFL)<<48)|(((long)array[7]&0xFFL)<<56);
	}

	public byte[] longToLittleEndianArray8(long number){
		byte[] array=new byte[8];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);
		array[4]=(byte)((number>>32)&0xFFL);
		array[5]=(byte)((number>>40)&0xFFL);
		array[6]=(byte)((number>>48)&0xFFL);
		array[7]=(byte)((number>>56)&0xFFL);

		return array;
	}

	public long littleEndianArray4ToLong(byte[] array){
		return(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24);
	}

	public byte[] longToLittleEndianArray4(long number){
		byte[] array=new byte[4];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);

		return array;
	}

	public int littleEndianArray4ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8)|(((int)array[2]&0xFF)<<16)|(((int)array[3]&0xFF)<<24);
	}

	public byte[] intToLittleEndianArray4(int number){
		byte[] array=new byte[4];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);

		return array;
	}

	static public int littleEndianArray2ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8);
	}

	public byte[] intToLittleEndianArray2(int number){
		byte[] array=new byte[2];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);

		return array;
	}

	public int littleEndianArray1ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0);
	}

	public byte[] intToLittleEndianArray1(int number){
		byte[] array=new byte[1];
		array[0]=(byte)((number>>0)&0xFFL);

		return array;
	}

	public short littleEndianArray2ToShort(byte[] array){
		return(short)(((((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8))&0xFFFF);
	}

	public byte[] shortToLittleEndianArray2(short number){
		byte[] array=new byte[2];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);

		return array;
	}

	public byte littleEndianArray1ToByte(byte[] array){
		return array[0];
	}

	public byte[] byteToLittleEndianArray1(byte number){
		byte[] array=new byte[1];
		array[0]=(byte)((number>>0)&0xFFL);

		return array;
	}

	public int getX(){
		return littleEndianArray4ToInt(x);
	}

	public void putX(int x){
		this.x=intToLittleEndianArray4(x);
	}

	public int getY(){
		return littleEndianArray4ToInt(y);
	}

	public void putY(int y){
		this.y=intToLittleEndianArray4(y);
	}

	public int getZ(){
		return littleEndianArray4ToInt(z);
	}

	public void putZ(int z){
			this.z=intToLittleEndianArray4(z);
	}

	public int getIntensity(){
		return littleEndianArray2ToInt(intensity);
	}

	public void putIntensity(int intensity){
		this.intensity=intToLittleEndianArray2(intensity);
	}

	public int getReturnNumber(){
		return littleEndianArray1ToInt(returnNumber);
	}

	public void putReturnNumber(int returnNumber){
		this.returnNumber=intToLittleEndianArray1(returnNumber);
	}

	public int getNumberOfReturns(){
		return littleEndianArray1ToInt(numberOfReturns);
	}

	public void putNumberOfReturns(int numberOfReturns){
		this.numberOfReturns=intToLittleEndianArray1(numberOfReturns);
	}

	public int getScanDirectionFlag(){
		return littleEndianArray1ToInt(scanDirectionFlag);
	}

	public void putScanDirectionFlag(int scanDirectionFlag){
		this.scanDirectionFlag=intToLittleEndianArray1(scanDirectionFlag);
	}

	public int getEdgeOfFlightLine(){
		return littleEndianArray1ToInt(edgeOfFlightLine);
	}

	public void putEdgeOfFlightLine(int edgeOfFlightLine){
		this.edgeOfFlightLine=intToLittleEndianArray1(edgeOfFlightLine);
	}

	public int getClassification(){
		return littleEndianArray1ToInt(classification);
	}

	public void putClassification(int classification){
		this.classification=intToLittleEndianArray1(classification);
	}

	public byte getScanAngleRank(){
		return littleEndianArray1ToByte(scanAngleRank);
	}

	public void putScanAngleRank(byte scanAngleRank){
		this.scanAngleRank=byteToLittleEndianArray1(scanAngleRank);
	}
//returned value should be int
	public long getFileMarker(){
		return littleEndianArray1ToInt(fileMarker);
	}

	public void putFileMarker(int fileMarker){
		this.fileMarker=intToLittleEndianArray1(fileMarker);
	}

	public short getUserBitField(){
		return littleEndianArray2ToShort(userBitField);
	}

	public void putUserBitField(short userBitField){
		this.userBitField=shortToLittleEndianArray2(userBitField);
	}

	public byte[] getExtraData(){
		if(extraData==null){
			byte[] dummyData=new byte[1];
			dummyData[0]='0';
			return dummyData;
		}else{
			return extraData;
		}
	}

	public void putExtraData(byte[] extraData){

			this.extraData=extraData;
	}

	public void print(){
		System.out.println("x "+getX());
		System.out.println("y "+getY());
		System.out.println("z "+getZ());
		System.out.println("intensity "+getIntensity());
		System.out.println("returnNumber "+getReturnNumber());
		System.out.println("numberOfReturns "+getNumberOfReturns());
		System.out.println("scanDirectionFlag "+getScanDirectionFlag());
		System.out.println("edgeOfFlightLine "+getEdgeOfFlightLine());
		System.out.println("classification "+getClassification());
		System.out.println("scanAngleRank "+getScanAngleRank());
		System.out.println("fileMarker "+getFileMarker());
		System.out.println("userBitField "+getUserBitField()+"  "+arrayToBits(userBitField));
	}

	public String arrayToBits(byte[] bytes){
		String string=new String();
		for(int a=0;a<bytes.length;a++){
			for(int b=7,c=1;b>-1;b--,c++){
				string+=(bytes[a]>>>b)&0x01;
				if(c==4||c==8){
					string+=" ";
				}
				if(c==8){
					string+=" ";
					c=0;
				}
			}
		}
		return string;
	}


	private void jbInit() throws Exception{
	}

	public static void main(String[] args){
	LASPointDataRecord laspointdatarecord=new LASPointDataRecord();
	laspointdatarecord.putClassification(12);
	System.out.println(laspointdatarecord.getClassification());
	laspointdatarecord.putUserBitField((short)222);
	System.out.println(laspointdatarecord.getUserBitField());
	laspointdatarecord.putX(667360796);
	System.out.println(laspointdatarecord.getX());
    }

}
